/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.graph.SuccessorsFunction;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Iterator;
import org.jspecify.annotations.NullMarked;

@NullMarked
@Beta
final class Printer<N> {
    private final SuccessorsFunction<N> tree;
    private final Appendable appendable;

    private Printer(SuccessorsFunction<N> tree, Appendable appendable) {
        this.tree = (SuccessorsFunction)Preconditions.checkNotNull(tree);
        this.appendable = (Appendable)Preconditions.checkNotNull((Object)appendable);
    }

    public static <N> Printer<N> forTree(SuccessorsFunction<N> tree) {
        return new Printer<N>(tree, System.out);
    }

    public Printer<N> appendingTo(Appendable appendable) {
        return new Printer<N>(this.tree, appendable);
    }

    public void print(N node) throws IOException {
        this.appendable.append(node.toString());
        this.appendable.append(StandardSystemProperty.LINE_SEPARATOR.value());
        ArrayDeque stack = new ArrayDeque();
        stack.push(this.tree.successors(node).iterator());
        while (!stack.isEmpty()) {
            Iterator top = (Iterator)stack.pop();
            if (!top.hasNext()) continue;
            for (Iterator iterator : stack) {
                this.appendable.append(iterator.hasNext() ? "\u2502\u00a0\u00a0 " : "    ");
            }
            Object next = top.next();
            this.appendable.append(top.hasNext() ? "\u251c\u2500\u2500 " : "\u2514\u2500\u2500 ");
            stack.push(top);
            stack.push(this.tree.successors(next).iterator());
            this.appendable.append(next.toString());
            this.appendable.append(StandardSystemProperty.LINE_SEPARATOR.value());
        }
    }

    public void print(Iterable<? extends N> nodes) throws IOException {
        for (N node : nodes) {
            this.print(node);
        }
    }
}

