/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.graph.SuccessorsFunction;
import java.util.StringJoiner;
import org.jspecify.annotations.NullMarked;

@NullMarked
@Beta
final class Stringifier<N> {
    private final SuccessorsFunction<N> tree;

    private Stringifier(SuccessorsFunction<N> tree) {
        this.tree = (SuccessorsFunction)Preconditions.checkNotNull(tree);
    }

    public static <N> Stringifier<N> forTree(SuccessorsFunction<N> tree) {
        return new Stringifier<N>(tree);
    }

    public String stringify(N node) {
        StringJoiner joiner = new StringJoiner(" ", "(", ")");
        joiner.add(String.valueOf(node));
        for (Object child : this.tree.successors(node)) {
            joiner.add(this.stringify(child));
        }
        return joiner.toString();
    }

    public String stringify(Iterable<? extends N> nodes) {
        StringJoiner joiner = new StringJoiner(" ");
        for (N node : nodes) {
            joiner.add(this.stringify(node));
        }
        return joiner.toString();
    }
}

