/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.i18n;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jspecify.annotations.NullMarked;
import pl.topteam.common.grammar.Przypadek;

@NullMarked
public final class Data {
    private static final String[] DZIEN = new String[]{"dzie\u0144", "dnia", "dniowi", "dzie\u0144", "dniem", "dniu", "dniu"};
    private static final String[][] DNI = new String[][]{{"poniedzia\u0142ek", "poniedzia\u0142ku", "poniedzia\u0142kowi", "poniedzia\u0142ek", "poniedzia\u0142kiem", "poniedzia\u0142ku", "poniedzia\u0142ku"}, {"wtorek", "wtorku", "wtorkowi", "wtorek", "wtorkiem", "wtorku", "wtorku"}, {"\u015broda", "\u015brody", "\u015brodzie", "\u015brod\u0119", "\u015brod\u0105", "\u015brodzie", "\u015brodo"}, {"czwartek", "czwartku", "czwartkowi", "czwartek", "czwartkiem", "czwartku", "czwartku"}, {"pi\u0105tek", "pi\u0105tku", "pi\u0105tkowi", "pi\u0105tek", "pi\u0105tkiem", "pi\u0105tku", "pi\u0105tku"}, {"sobota", "soboty", "sobocie", "sobot\u0119", "sobot\u0105", "sobocie", "soboto"}, {"niedziela", "niedzieli", "niedzieli", "niedziel\u0119", "niedziel\u0105", "niedzieli", "niedzielo"}};
    private static final String[] MIESIAC = new String[]{"miesi\u0105c", "miesi\u0105ca", "miesi\u0105cowi", "miesi\u0105c", "miesi\u0105cem", "miesi\u0105cu", "miesi\u0105cu"};
    private static final String[][] MIESIACE = new String[][]{{"stycze\u0144", "stycznia", "styczniowi", "stycze\u0144", "styczniem", "styczniu", "styczniu"}, {"luty", "lutego", "lutemu", "luty", "lutym", "lutym", "luty"}, {"marzec", "marca", "marcowi", "marzec", "marcem", "marcu", "marcu"}, {"kwiecie\u0144", "kwietnia", "kwietniowi", "kwiecie\u0144", "kwietniem", "kwietniu", "kwietniu"}, {"maj", "maja", "majowi", "maj", "majem", "maju", "maju"}, {"czerwiec", "czerwca", "czerwcowi", "czerwiec", "czerwcem", "czerwcu", "czerwcu"}, {"lipiec", "lipca", "lipcowi", "lipiec", "lipcem", "lipcu", "lipcu"}, {"sierpie\u0144", "sierpnia", "sierpniowi", "sierpie\u0144", "sierpniem", "sierpniu", "sierpniu"}, {"wrzesie\u0144", "wrze\u015bnia", "wrze\u015bniowi", "wrzesie\u0144", "wrze\u015bniem", "wrze\u015bniu", "wrze\u015bniu"}, {"pa\u017adziernik", "pa\u017adziernika", "pa\u017adziernikowi", "pa\u017adziernik", "pa\u017adziernikiem", "pa\u017adzierniku", "pa\u017adzierniku"}, {"listopad", "listopada", "listopadowi", "listopad", "listopadem", "listopadzie", "listopadzie"}, {"grudzie\u0144", "grudnia", "grudniowi", "grudzie\u0144", "grudniem", "grudniu", "grudniu"}};
    private static final String[] ROK = new String[]{"rok", "roku", "rokowi", "rok", "rokiem", "roku", "roku"};

    private Data() {
    }

    public static String dzien(@NonNull Przypadek p) {
        return DZIEN[p.ordinal()];
    }

    public static String dzien(@NonNull DayOfWeek d, @NonNull Przypadek p) {
        return DNI[d.ordinal()][p.ordinal()];
    }

    public static String miesiac(@NonNull Przypadek p) {
        return MIESIAC[p.ordinal()];
    }

    public static String miesiac(@NonNull Month m, @NonNull Przypadek p) {
        return MIESIACE[m.ordinal()][p.ordinal()];
    }

    public static String rok(@NonNull Przypadek p) {
        return ROK[p.ordinal()];
    }

    public static String slownie(@NonNull LocalDate d) {
        int _r = d.getYear();
        Month _m = d.getMonth();
        int _d = d.getDayOfMonth();
        return String.format("%d %s %d r.", _d, Data.miesiac(_m, Przypadek.DOPE\u0141NIACZ), _r);
    }
}

