/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.i18n;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.NavigableMap;
import pl.topteam.common.grammar.Kategoria;
import pl.topteam.common.grammar.Liczba;
import pl.topteam.common.grammar.Osobowosc;
import pl.topteam.common.grammar.Przypadek;
import pl.topteam.common.grammar.Rodzaj;
import pl.topteam.common.grammar.Zwiazek;
import pl.topteam.common.grammar.Zywotnosc;
import pl.topteam.common.i18n.Deklinacja;
import pl.topteam.common.i18n.LiczebnikGlowny1000;
import pl.topteam.common.i18n.Liczebniki;
import pl.topteam.common.i18n.Mnozne;

@Beta
final class LiczebnikGlowny {
    private static final NavigableMap<Long, String[][][][]> DEKLINACJA = Deklinacja.wczytaj("LiczebnikGlowny.csv", Rodzaj.class, Zywotnosc.class, Osobowosc.class, Przypadek.class);

    private LiczebnikGlowny() {
    }

    private static Liczba liczba(long x) {
        assert (x >= 0L);
        return x == 1L ? Liczba.POJEDYNCZA : Liczba.MNOGA;
    }

    private static Zwiazek zwiazek(long x) {
        assert (x >= 0L);
        assert (x <= 999L);
        if (x <= 0L) {
            return Zwiazek.RZ\u0104DU;
        }
        if (x <= 1L) {
            return Zwiazek.ZGODY;
        }
        if (x <= 4L) {
            return Zwiazek.ZGODY;
        }
        if (x <= 19L) {
            return Zwiazek.RZ\u0104DU;
        }
        if (x % 10L <= 1L) {
            return Zwiazek.RZ\u0104DU;
        }
        if (x % 10L <= 4L) {
            return Zwiazek.ZGODY;
        }
        if (x % 10L <= 9L) {
            return Zwiazek.RZ\u0104DU;
        }
        throw new AssertionError();
    }

    private static Przypadek przypadek(Przypadek p, Zwiazek z) {
        return switch (z) {
            default -> throw new MatchException(null, null);
            case Zwiazek.ZGODY -> p;
            case Zwiazek.RZ\u0104DU -> {
                switch (p) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case MIANOWNIK: 
                    case BIERNIK: 
                    case WO\u0141ACZ: {
                        yield Przypadek.DOPE\u0141NIACZ;
                    }
                    case DOPE\u0141NIACZ: 
                    case CELOWNIK: 
                    case NARZ\u0118DNIK: 
                    case MIEJSCOWNIK: 
                }
                yield p;
            }
            case Zwiazek.PRZYNALE\u017bNO\u015aCI -> throw new AssertionError();
        };
    }

    private static String deklinacja(long x, Rodzaj r, Zywotnosc z, Osobowosc o, Przypadek p) {
        return ((String[][][][])DEKLINACJA.get(x))[r.ordinal()][z.ordinal()][o.ordinal()][p.ordinal()];
    }

    public static String slownie(long l, Kategoria ... k) {
        Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (String)"Liczba musi by\u0107 nieujemna, przekazano: %s", (long)l);
        Rodzaj rodzaj = (Rodzaj)FluentIterable.from((Object[])k).filter(Rodzaj.class).last().or((Object)Rodzaj.M\u0118SKI);
        Zywotnosc zywotnosc = (Zywotnosc)FluentIterable.from((Object[])k).filter(Zywotnosc.class).last().or((Object)Zywotnosc.NIE\u017bYWOTNY);
        Osobowosc osobowosc = (Osobowosc)FluentIterable.from((Object[])k).filter(Osobowosc.class).last().or((Object)Osobowosc.NIEOSOBOWY);
        Przypadek przypadek = (Przypadek)FluentIterable.from((Object[])k).filter(Przypadek.class).last().or((Object)Przypadek.MIANOWNIK);
        if (DEKLINACJA.containsKey(l)) {
            return LiczebnikGlowny.deklinacja(l, rodzaj, zywotnosc, osobowosc, przypadek);
        }
        ArrayList<String> slowa = new ArrayList<String>();
        long[] mnozne = Mnozne.mnozne(l).toArray();
        for (int potega = mnozne.length - 1; potega >= 0; --potega) {
            long[] liczebniki;
            long mnozna = mnozne[potega];
            if (mnozna <= 0L) continue;
            for (long liczebnik : liczebniki = Liczebniki.liczebniki(mnozna).toArray()) {
                assert (liczebnik != 0L);
                if (liczebnik == 1L) {
                    if (potega != 0 && mnozna <= 1L) continue;
                    slowa.add(LiczebnikGlowny.deklinacja(liczebnik, Rodzaj.M\u0118SKI, Zywotnosc.NIE\u017bYWOTNY, Osobowosc.NIEOSOBOWY, Przypadek.MIANOWNIK));
                    continue;
                }
                if (potega > 0) {
                    slowa.add(LiczebnikGlowny.deklinacja(liczebnik, Rodzaj.M\u0118SKI, Zywotnosc.NIE\u017bYWOTNY, Osobowosc.NIEOSOBOWY, przypadek));
                    continue;
                }
                if (rodzaj == Rodzaj.M\u0118SKI && osobowosc == Osobowosc.OSOBOWY) {
                    slowa.add(LiczebnikGlowny.deklinacja(liczebnik, rodzaj, zywotnosc, osobowosc, LiczebnikGlowny.przypadek(przypadek, Zwiazek.RZ\u0104DU)));
                    continue;
                }
                slowa.add(LiczebnikGlowny.deklinacja(liczebnik, rodzaj, zywotnosc, osobowosc, przypadek));
            }
            if (potega <= 0) continue;
            slowa.add(LiczebnikGlowny1000.slownie(potega, LiczebnikGlowny.przypadek(przypadek, LiczebnikGlowny.zwiazek(mnozna)), LiczebnikGlowny.liczba(mnozna)));
        }
        return Joiner.on((String)" ").join(slowa);
    }
}

