/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.i18n;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.math.LongMath;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NavigableMap;
import pl.topteam.common.grammar.Kategoria;
import pl.topteam.common.grammar.Liczba;
import pl.topteam.common.grammar.Osobowosc;
import pl.topteam.common.grammar.Przypadek;
import pl.topteam.common.grammar.Rodzaj;
import pl.topteam.common.grammar.Zywotnosc;
import pl.topteam.common.i18n.Deklinacja;
import pl.topteam.common.i18n.LiczebnikGlowny;
import pl.topteam.common.i18n.LiczebnikPorzadkowy1000;
import pl.topteam.common.i18n.Liczebniki;
import pl.topteam.common.i18n.Mnozne;
import pl.topteam.common.primitives.ExtraLongs;

@Beta
final class LiczebnikPorzadkowy {
    private static final NavigableMap<Long, String> PREFIKSY_SETEK = ImmutableSortedMap.naturalOrder().put((Object)100L, (Object)"").put((Object)200L, (Object)"dwu").put((Object)300L, (Object)"trzech").put((Object)400L, (Object)"czterech").put((Object)500L, (Object)"pi\u0119\u0107").put((Object)600L, (Object)"sze\u015b\u0107").put((Object)700L, (Object)"siedem").put((Object)800L, (Object)"osiem").put((Object)900L, (Object)"dziewi\u0119\u0107").build();
    private static final NavigableMap<Long, String> PREFIKSY_TYSI\u0118CY = ImmutableSortedMap.naturalOrder().put((Object)1L, (Object)"jeden").put((Object)2L, (Object)"dwu").put((Object)3L, (Object)"trzy").put((Object)4L, (Object)"cztero").put((Object)5L, (Object)"pi\u0119cio").put((Object)6L, (Object)"sze\u015bcio").put((Object)7L, (Object)"siedmio").put((Object)8L, (Object)"o\u015bmio").put((Object)9L, (Object)"dziewi\u0119cio").put((Object)10L, (Object)"dziesi\u0119cio").put((Object)11L, (Object)"jedenasto").put((Object)12L, (Object)"dwunasto").put((Object)13L, (Object)"trzynasto").put((Object)14L, (Object)"czternasto").put((Object)15L, (Object)"pi\u0119tnasto").put((Object)16L, (Object)"szesnasto").put((Object)17L, (Object)"siedemnasto").put((Object)18L, (Object)"osiemmnasto").put((Object)19L, (Object)"dziewi\u0119tnasto").put((Object)20L, (Object)"dwudziesto").put((Object)30L, (Object)"trzydziesto").put((Object)40L, (Object)"czterdziesto").put((Object)50L, (Object)"pi\u0119\u0107dziesi\u0119cio").put((Object)60L, (Object)"sze\u015b\u0107dziesi\u0119cio").put((Object)70L, (Object)"siedemdziesi\u0119cio").put((Object)80L, (Object)"osiemdziesi\u0119cio").put((Object)90L, (Object)"dziewi\u0119\u0107dziesi\u0119cio").put((Object)100L, (Object)"stu").put((Object)200L, (Object)"dwustu").put((Object)300L, (Object)"trzystu").put((Object)400L, (Object)"czterystu").put((Object)500L, (Object)"pi\u0119ciuset").put((Object)600L, (Object)"sze\u015bciuset").put((Object)700L, (Object)"siedmiuset").put((Object)800L, (Object)"o\u015bmiuset").put((Object)900L, (Object)"dziewi\u0119ciuset").build();
    private static final NavigableMap<Long, String[][][][][]> DEKLINACJA = Deklinacja.wczytaj("LiczebnikPorzadkowy.csv", Rodzaj.class, Zywotnosc.class, Osobowosc.class, Liczba.class, Przypadek.class);

    private LiczebnikPorzadkowy() {
    }

    private static String deklinacja(long x, Rodzaj r, Zywotnosc z, Osobowosc o, Liczba l, Przypadek p) {
        return ((String[][][][][])DEKLINACJA.get(x))[r.ordinal()][z.ordinal()][o.ordinal()][l.ordinal()][p.ordinal()];
    }

    public static String slownie(long l, Kategoria ... k) {
        Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (String)"Liczba musi by\u0107 nieujemna, przekazano: %s", (long)l);
        Rodzaj rodzaj = (Rodzaj)FluentIterable.from((Object[])k).filter(Rodzaj.class).last().or((Object)Rodzaj.M\u0118SKI);
        Zywotnosc zywotnosc = (Zywotnosc)FluentIterable.from((Object[])k).filter(Zywotnosc.class).last().or((Object)Zywotnosc.NIE\u017bYWOTNY);
        Osobowosc osobowosc = (Osobowosc)FluentIterable.from((Object[])k).filter(Osobowosc.class).last().or((Object)Osobowosc.NIEOSOBOWY);
        Liczba liczba = (Liczba)FluentIterable.from((Object[])k).filter(Liczba.class).last().or((Object)Liczba.POJEDYNCZA);
        Przypadek przypadek = (Przypadek)FluentIterable.from((Object[])k).filter(Przypadek.class).last().or((Object)Przypadek.MIANOWNIK);
        if (DEKLINACJA.containsKey(l)) {
            return LiczebnikPorzadkowy.deklinacja(l, rodzaj, zywotnosc, osobowosc, liczba, przypadek);
        }
        long[] mnozne = Mnozne.mnozne(l).toArray();
        int potega = Iterables.indexOf((Iterable)Longs.asList((long[])mnozne), mnozna -> mnozna > 0L);
        assert (potega >= 0) : "@AssumeAssertion(index)";
        assert (potega < mnozne.length) : "@AssumeAssertion(index)";
        long mnozna2 = mnozne[potega];
        long glowny = l - mnozna2 * LongMath.pow((long)1000L, (int)potega);
        long[] liczebniki = Liczebniki.liczebniki(mnozna2).toArray();
        int indeks = mnozna2 >= 100L && liczebniki.length >= 2 ? 1 : 0;
        ArrayList<String> slowa = new ArrayList<String>();
        if (glowny > 0L) {
            slowa.add(LiczebnikGlowny.slownie(glowny, new Kategoria[0]));
        }
        if (indeks > 0) {
            slowa.add(LiczebnikGlowny.slownie(ExtraLongs.first(liczebniki), new Kategoria[0]));
        }
        ArrayList<Object> sufiks = new ArrayList<Object>();
        if (potega == 0) {
            Iterator iterator = Iterables.skip((Iterable)Longs.asList((long[])liczebniki), (int)indeks).iterator();
            while (iterator.hasNext()) {
                long liczebnik = (Long)iterator.next();
                if (liczebnik >= 100L) {
                    String prefiks = (String)PREFIKSY_SETEK.get(liczebnik);
                    assert (prefiks != null) : "@AssumeAssertion(nullness)";
                    sufiks.add(prefiks + LiczebnikPorzadkowy.deklinacja(100L, rodzaj, zywotnosc, osobowosc, liczba, przypadek));
                    continue;
                }
                sufiks.add(LiczebnikPorzadkowy.deklinacja(liczebnik, rodzaj, zywotnosc, osobowosc, liczba, przypadek));
            }
            slowa.add(Joiner.on((String)" ").join(sufiks));
        } else {
            if (mnozna2 != 1L) {
                Iterator iterator = Iterables.skip((Iterable)Longs.asList((long[])liczebniki), (int)indeks).iterator();
                while (iterator.hasNext()) {
                    long liczebnik = (Long)iterator.next();
                    String prefiks = (String)PREFIKSY_TYSI\u0118CY.get(liczebnik);
                    assert (prefiks != null) : "@AssumeAssertion(nullness)";
                    sufiks.add(prefiks);
                }
                if (mnozna2 % 100L == 1L) {
                    sufiks.add(" ");
                }
            }
            sufiks.add(LiczebnikPorzadkowy1000.slownie(potega, rodzaj, zywotnosc, osobowosc, liczba, przypadek));
            slowa.add(Joiner.on((String)"").join(sufiks));
        }
        return Joiner.on((String)" ").join(slowa);
    }
}

