/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.io;

import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

@Immutable
public final class MazoviaCharset
extends Charset {
    private static final String NAME = "cp790";
    private static final String[] ALIASES = new String[]{"mazovia", "cp620", "cp896"};
    private static final char[] CHARS = new char[256];
    private static final byte[] BYTES = new byte[65536];

    public MazoviaCharset() {
        super(NAME, ALIASES);
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.equals(this) || cs.equals(StandardCharsets.US_ASCII);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new MazoviaDecoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new MazoviaEncoder(this);
    }

    static {
        URL url = Resources.getResource((String)"mazovia.csv");
        CharSource source = Resources.asCharSource((URL)url, (Charset)StandardCharsets.UTF_8);
        try {
            ImmutableList lines = source.readLines();
            for (String line : lines) {
                int b = Integer.parseUnsignedInt(line.substring(2, 4), 16);
                int c = Integer.parseUnsignedInt(line.substring(8, 12), 16);
                assert (b >= 0) : "@AssumeAssertion(index)";
                assert (b < CHARS.length) : "@AssumeAssertion(index)";
                MazoviaCharset.CHARS[b] = (char)c;
                assert (c >= 0) : "@AssumeAssertion(index)";
                assert (c < BYTES.length) : "@AssumeAssertion(index)";
                MazoviaCharset.BYTES[c] = (byte)b;
            }
        }
        catch (IOException wyjatek) {
            throw new UncheckedIOException(wyjatek);
        }
    }

    private static final class MazoviaDecoder
    extends CharsetDecoder {
        MazoviaDecoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                byte b = in.get();
                int i = Byte.toUnsignedInt(b);
                assert (i >= 0) : "@AssumeAssertion(index)";
                assert (i < CHARS.length) : "@AssumeAssertion(index)";
                char c = CHARS[i];
                out.put(c);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private static final class MazoviaEncoder
    extends CharsetEncoder {
        MazoviaEncoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.hasRemaining()) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char c = in.get();
                byte b = BYTES[c];
                if (!this.canEncode(c)) {
                    return CoderResult.unmappableForLength(1);
                }
                out.put(b);
            }
            return CoderResult.UNDERFLOW;
        }

        @Override
        public boolean canEncode(char c) {
            assert (c < BYTES.length) : "@AssumeAssertion(index)";
            byte b = BYTES[c];
            int i = Byte.toUnsignedInt(b);
            assert (i < CHARS.length) : "@AssumeAssertion(index)";
            return c == CHARS[i];
        }
    }
}

