/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.format.kontakty;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.Immutable;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.springframework.format.Printer;
import pl.topteam.common.model.kontakty.Adres;

@Immutable
@NullMarked
@Beta
public final class AdresPrinter
implements Printer<Adres> {
    private static final Joiner outerJoiner = Joiner.on((String)"\n").skipNulls();
    private static final Joiner innerJoiner = Joiner.on((String)" ").skipNulls();

    public String print(Adres adres, Locale locale) {
        return outerJoiner.join((Object)innerJoiner.join((Object)this.ulica(adres), (Object)this.budynek(adres), new Object[]{this.lokal(adres)}), (Object)innerJoiner.join((Object)this.kod(adres), (Object)this.miejscowosc(adres), new Object[0]), new Object[0]);
    }

    private @Nullable String ulica(Adres adres) {
        return Stream.of(adres.getUlica(), adres.getMiejscowosc()).map(Strings::emptyToNull).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private @Nullable String budynek(Adres adres) {
        return Strings.emptyToNull((String)adres.getBudynek());
    }

    private @Nullable String lokal(Adres adres) {
        String lokal = Strings.emptyToNull((String)adres.getLokal());
        return lokal != null ? "lok. " + lokal : null;
    }

    private @Nullable String kod(Adres adres) {
        return Strings.emptyToNull((String)adres.getKod());
    }

    private @Nullable String miejscowosc(Adres adres) {
        return Strings.emptyToNull((String)adres.getMiejscowosc());
    }
}

