/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.model;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import org.jspecify.annotations.NullMarked;
import pl.topteam.common.model.AutoValue_NRB;
import pl.topteam.common.model.IBAN;

@Immutable
@NullMarked
@AutoValue
public abstract class NRB
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ALPHA2 = 2;

    protected NRB() {
    }

    public static NRB valueOf(String numer) {
        Preconditions.checkArgument((boolean)pl.topteam.common.validation.NRB.isValid(numer), (String)"Niepoprawny NRB: %s", (Object)numer);
        return new AutoValue_NRB(numer);
    }

    public abstract String value();

    public static NRB from(IBAN iban) {
        Preconditions.checkArgument((boolean)iban.value().startsWith("PL"), (String)"Brak NRB dla: %s", (Object)iban);
        assert (iban.value().length() >= 2) : "@AssumeAssertion(index)";
        return NRB.valueOf(iban.value().substring(2));
    }

    public IBAN toIBAN() {
        return IBAN.valueOf("PL" + this.value());
    }
}

