/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.model.dokumenty;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.regex.Pattern;
import pl.topteam.common.base.Digits;
import pl.topteam.common.model.dokumenty.AutoValue_DowodOsobisty;
import pl.topteam.common.primitives.ExtraInts;

@Immutable
@Beta
@AutoValue
public abstract class DowodOsobisty
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN = Pattern.compile("[A-Z]{3}[0-9]{6}");
    private static final int[] WEIGHTS = new int[]{7, 3, 1, 9, 7, 3, 1, 7, 3};

    public static DowodOsobisty valueOf(String numer) {
        Preconditions.checkNotNull((Object)numer);
        Preconditions.checkArgument((boolean)PATTERN.matcher(numer).matches(), (String)"Niepoprawny format numeru dowodu osobistego: %s", (Object)numer);
        int[] digits = Digits.of((String)numer);
        int product = ExtraInts.product((int[])digits, (int[])WEIGHTS);
        Preconditions.checkArgument((product % 10 == 0 ? 1 : 0) != 0, (String)"B\u0142\u0119dna suma kontrolna numeru dowodu osobistego: %s", (Object)numer);
        return new AutoValue_DowodOsobisty(numer);
    }

    public abstract String value();
}

