/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.jspecify.annotations.NullMarked;
import pl.topteam.common.base.Digits;

@NullMarked
public final class IBAN {
    private static final int ALPHA2 = 2;
    private static final int CHECKSUM = 2;
    private static final ImmutableMap<String, Pattern> REGISTRY;

    private IBAN() {
    }

    private static String translate(String pattern) {
        return pattern.replaceAll("(?<count>[0-9]+)!n", "\\\\p{Digit}{${count}}").replaceAll("(?<count>[0-9]+)!a", "\\\\p{Upper}{${count}}").replaceAll("(?<count>[0-9]+)!c", "\\\\p{Alnum}{${count}}");
    }

    public static boolean isValid(String iban) {
        Preconditions.checkNotNull((Object)iban);
        if (iban.length() < 2) {
            return false;
        }
        String alpha2 = iban.substring(0, 2);
        if (!REGISTRY.containsKey((Object)alpha2)) {
            return false;
        }
        Pattern pattern = (Pattern)REGISTRY.get((Object)alpha2);
        if (!pattern.matcher(iban).matches()) {
            return false;
        }
        assert (iban.length() >= 4) : "@AssumeAssertion(index)";
        String _iban = iban.substring(4) + iban.substring(0, 4);
        String _digits = Ints.join((String)"", (int[])Digits.of((String)_iban));
        BigInteger _number = new BigInteger(_digits);
        return _number.remainder(BigInteger.valueOf(97L)).equals(BigInteger.valueOf(1L));
    }

    static {
        try {
            URL url = Resources.getResource((String)"iban.txt");
            ImmutableMap.Builder registry = ImmutableMap.builder();
            for (String pattern : Resources.readLines((URL)url, (Charset)StandardCharsets.UTF_8)) {
                assert (pattern.length() >= 2) : "@AssumeAssertion(index)";
                String alpha2 = pattern.substring(0, 2);
                registry.put((Object)alpha2, (Object)Pattern.compile(IBAN.translate(pattern)));
            }
            REGISTRY = registry.build();
        }
        catch (IOException wyjatek) {
            throw new UncheckedIOException(wyjatek);
        }
    }
}

