/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.validation;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.checkerframework.checker.regex.qual.Regex;

public final class KTS {
    private static final @Regex String mr = "[0-9]{2}(?<!0{2})";
    private static final @Regex String ww = "[0-9]{2}(?<!0{2})";
    private static final @Regex String r = "[0-9]{1}(?<!0{1})";
    private static final @Regex String pr = "[0-9]{2}(?<!0{2})";
    private static final @Regex String pp = "[0-9]{2}(?<!0{2})";
    private static final @Regex String gg = "[0-9]{2}(?<!0{2})";
    private static final @Regex String j = "[0-9]{1}(?<!0{1})";
    private static final @Regex String z = "[0]{1}";
    private static final @Regex String zz = "[0]{2}";
    private static final @Regex Pattern MAKROREGION = Pattern.compile("10[0-9]{2}(?<!0{2})[0]{2}[0]{1}[0]{2}[0]{2}[0]{2}[0]{1}");
    private static final @Regex Pattern WOJEWODZTWO = Pattern.compile("10[0-9]{2}(?<!0{2})[0-9]{2}(?<!0{2})[0]{1}[0]{2}[0]{2}[0]{2}[0]{1}");
    private static final @Regex Pattern REGION = Pattern.compile("10[0-9]{2}(?<!0{2})[0-9]{2}(?<!0{2})[0-9]{1}(?<!0{1})[0]{2}[0]{2}[0]{2}[0]{1}");
    private static final @Regex Pattern PODREGION = Pattern.compile("10[0-9]{2}(?<!0{2})[0-9]{2}(?<!0{2})[0-9]{1}(?<!0{1})[0-9]{2}(?<!0{2})[0]{2}[0]{2}[0]{1}");
    private static final @Regex Pattern POWIAT = Pattern.compile("10[0-9]{2}(?<!0{2})[0-9]{2}(?<!0{2})[0-9]{1}(?<!0{1})[0-9]{2}(?<!0{2})[0-9]{2}(?<!0{2})[0]{2}[0]{1}");
    private static final @Regex Pattern GMINA = Pattern.compile("10[0-9]{2}(?<!0{2})[0-9]{2}(?<!0{2})[0-9]{1}(?<!0{1})[0-9]{2}(?<!0{2})[0-9]{2}(?<!0{2})[0-9]{2}(?<!0{2})[0-9]{1}(?<!0{1})");
    private static final Pattern[] PATTERNS = new Pattern[]{MAKROREGION, WOJEWODZTWO, REGION, PODREGION, POWIAT, GMINA};

    private KTS() {
    }

    public static boolean isValid(String kts) {
        Preconditions.checkNotNull((Object)kts);
        return Arrays.stream(PATTERNS).anyMatch(p -> p.matcher(kts).matches());
    }
}

