/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.validation;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.regex.qual.Regex;
import pl.topteam.common.base.Digits;
import pl.topteam.common.primitives.ExtraInts;

public final class NIP {
    private static final @Regex Pattern PATTERN = Pattern.compile("[0-9]{10}");
    private static final @Positive int[] WEIGHTS = new int[]{6, 5, 7, 2, 3, 4, 5, 6, 7};

    private NIP() {
    }

    public static boolean isValid(String nip) {
        Preconditions.checkNotNull((Object)nip);
        if (PATTERN.matcher(nip).matches()) {
            int[] digits = Digits.of((String)nip);
            int product = ExtraInts.product((int[])ExtraInts.first((int[])digits, (int)-1), (int[])WEIGHTS);
            int chsum = product % 11;
            return ExtraInts.last((int[])digits) == chsum;
        }
        return false;
    }
}

