/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.validation;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.regex.Pattern;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.regex.qual.Regex;
import pl.topteam.common.base.Digits;
import pl.topteam.common.primitives.ExtraInts;

public final class PESEL {
    private static final @Regex Pattern PATTERN = Pattern.compile("[0-9]{11}");
    private static final @Positive int[] WEIGHTS = new int[]{1, 3, 7, 9, 1, 3, 7, 9, 1, 3};
    private static final @Positive int[] ONE = new int[]{1};

    private PESEL() {
    }

    public static boolean isValid(String pesel) {
        Preconditions.checkNotNull((Object)pesel);
        if (PATTERN.matcher(pesel).matches()) {
            int[] digits = Digits.of((String)pesel);
            int product = ExtraInts.product((int[])digits, (int[])Ints.concat((int[][])new int[][]{WEIGHTS, ONE}));
            return product % 10 == 0;
        }
        return false;
    }
}

