/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.regex.qual.Regex;
import pl.topteam.common.base.Digits;
import pl.topteam.common.primitives.ExtraInts;

public final class REGON {
    private static final @Regex Pattern PATTERN = Pattern.compile("[0-9]{9}|[0-9]{14}");
    private static final Map<@NonNegative Integer, @NonNegative int[]> WEIGHTS = ImmutableMap.of((Object)9, (Object)new int[]{8, 9, 2, 3, 4, 5, 6, 7}, (Object)14, (Object)new int[]{2, 4, 8, 5, 0, 9, 7, 3, 6, 1, 2, 4, 8});

    private REGON() {
    }

    public static boolean isValid(String regon) {
        Preconditions.checkNotNull((Object)regon);
        if (PATTERN.matcher(regon).matches()) {
            int[] weigths = WEIGHTS.get(regon.length());
            assert (weigths != null) : "@AssumeAssertion(nullness): Zagwarantowane przez wyra\u017cenie regularne";
            int[] digits = Digits.of((String)regon);
            int product = ExtraInts.product((int[])ExtraInts.first((int[])digits, (int)-1), (int[])weigths);
            int chsum = product % 11;
            return ExtraInts.last((int[])digits) == chsum % 10;
        }
        return false;
    }
}

