/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Cleaner {
    private Cleaner() {
    }

    private static Object createCleaner() {
        try {
            return Class.forName("java.lang.ref.Cleaner").getMethod("create", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object getInstance() {
        return LazyHolder.INSTANCE;
    }

    public static Cleanable register(Object object, final Runnable runnable) {
        if (object == null) {
            throw new IllegalArgumentException("object must not be null");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable must not be null");
        }
        Object cleaner = Cleaner.getInstance();
        try {
            Runnable wrappedRunnable = new Runnable(){
                private volatile boolean cleaned = false;

                private synchronized boolean isCleaned() {
                    boolean cleaned = this.cleaned;
                    this.cleaned = true;
                    return cleaned;
                }

                @Override
                public void run() {
                    if (!this.isCleaned()) {
                        runnable.run();
                    }
                }
            };
            if (cleaner == null) {
                return new Cleanable(wrappedRunnable);
            }
            Object cleanable = cleaner.getClass().getMethod("register", Object.class, Runnable.class).invoke(cleaner, object, wrappedRunnable);
            return new Cleanable(wrappedRunnable);
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable);
        }
    }

    public static Cleanable register(final Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object must not be null");
        }
        Object cleaner = Cleaner.getInstance();
        try {
            final Method method = object.getClass().getMethod("clean", new Class[0]);
            Runnable runnable = new Runnable(){
                private volatile boolean cleaned = false;

                private synchronized boolean isCleaned() {
                    boolean cleaned = this.cleaned;
                    this.cleaned = true;
                    return cleaned;
                }

                @Override
                public void run() {
                    if (this.isCleaned()) {
                        return;
                    }
                    try {
                        method.invoke(object, new Object[0]);
                    }
                    catch (InvocationTargetException exception) {
                        Throwable throwable = exception.getCause();
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        throw new AssertionError((Object)throwable);
                    }
                    catch (Throwable throwable) {
                        throw new AssertionError((Object)throwable);
                    }
                }
            };
            if (cleaner == null) {
                return new Cleanable(runnable);
            }
            Object cleanable = cleaner.getClass().getMethod("register", Object.class, Runnable.class).invoke(cleaner, object, runnable);
            return new Cleanable(runnable);
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable);
        }
    }

    static /* synthetic */ Object access$000() {
        return Cleaner.createCleaner();
    }

    public static class Cleanable {
        private final Object cleanable;

        private Cleanable(Object cleanable) {
            this.cleanable = cleanable;
        }

        public void clean() throws Exception {
            try {
                this.cleanable.getClass().getMethod("run", new Class[0]).invoke(this.cleanable, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new AssertionError((Object)throwable);
            }
            catch (Throwable throwable) {
                throw new AssertionError((Object)throwable);
            }
        }
    }

    private static class LazyHolder {
        static final Object INSTANCE = Cleaner.access$000();

        private LazyHolder() {
        }
    }
}

