/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.AttributeArray;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.ECDSAPublicKey;
import iaik.pkcs.pkcs11.objects.KEAPublicKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.X942DHPublicKey;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class PublicKey
extends Key {
    protected ByteArrayAttribute subject_;
    protected BooleanAttribute encrypt_;
    protected BooleanAttribute verify_;
    protected BooleanAttribute verifyRecover_;
    protected BooleanAttribute wrap_;
    protected BooleanAttribute trusted_;
    protected AttributeArray wrapTemplate_;

    public PublicKey() {
        this.objectClass_.setLongValue(Object.ObjectClass.PUBLIC_KEY);
    }

    protected PublicKey(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass_.setLongValue(Object.ObjectClass.PUBLIC_KEY);
    }

    public static Object getInstance(Session session, long objectHandle) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        KeyTypeAttribute keyTypeAttribute = new KeyTypeAttribute();
        PublicKey.getAttributeValue(session, objectHandle, keyTypeAttribute);
        Long keyType = keyTypeAttribute.getLongValue();
        Object newObject = keyTypeAttribute.isPresent() && keyType != null ? (keyType.equals(Key.KeyType.RSA) ? RSAPublicKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.DSA) ? DSAPublicKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.ECDSA) ? ECDSAPublicKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.DH) ? DHPublicKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.KEA) ? KEAPublicKey.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.X9_42_DH) ? X942DHPublicKey.getInstance(session, objectHandle) : ((keyType & Key.KeyType.VENDOR_DEFINED) != 0L ? PublicKey.getUnknownPublicKey(session, objectHandle) : PublicKey.getUnknownPublicKey(session, objectHandle)))))))) : PublicKey.getUnknownPublicKey(session, objectHandle);
        return newObject;
    }

    protected static Object getUnknownPublicKey(Session session, long objectHandle) throws TokenException {
        Object newObject;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        if (Key.vendorKeyBuilder_ != null) {
            try {
                newObject = Key.vendorKeyBuilder_.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new PublicKey(session, objectHandle);
            }
        } else {
            newObject = new PublicKey(session, objectHandle);
        }
        return newObject;
    }

    protected static void putAttributesInTable(PublicKey object) {
        if (object == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        object.attributeTable_.put(Attribute.SUBJECT, object.subject_);
        object.attributeTable_.put(Attribute.ENCRYPT, object.encrypt_);
        object.attributeTable_.put(Attribute.VERIFY, object.verify_);
        object.attributeTable_.put(Attribute.VERIFY_RECOVER, object.verifyRecover_);
        object.attributeTable_.put(Attribute.WRAP, object.wrap_);
        object.attributeTable_.put(Attribute.TRUSTED, object.trusted_);
        object.attributeTable_.put(Attribute.WRAP_TEMPLATE, object.wrapTemplate_);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.subject_ = new ByteArrayAttribute(Attribute.SUBJECT);
        this.encrypt_ = new BooleanAttribute(Attribute.ENCRYPT);
        this.verify_ = new BooleanAttribute(Attribute.VERIFY);
        this.verifyRecover_ = new BooleanAttribute(Attribute.VERIFY_RECOVER);
        this.wrap_ = new BooleanAttribute(Attribute.WRAP);
        this.trusted_ = new BooleanAttribute(Attribute.TRUSTED);
        this.wrapTemplate_ = new AttributeArray(Attribute.WRAP_TEMPLATE);
        PublicKey.putAttributesInTable(this);
    }

    @Override
    public java.lang.Object clone() {
        PublicKey clone = (PublicKey)super.clone();
        clone.subject_ = (ByteArrayAttribute)this.subject_.clone();
        clone.encrypt_ = (BooleanAttribute)this.encrypt_.clone();
        clone.verify_ = (BooleanAttribute)this.verify_.clone();
        clone.verifyRecover_ = (BooleanAttribute)this.verifyRecover_.clone();
        clone.wrap_ = (BooleanAttribute)this.wrap_.clone();
        clone.trusted_ = (BooleanAttribute)this.trusted_.clone();
        clone.wrapTemplate_ = (AttributeArray)this.wrapTemplate_.clone();
        PublicKey.putAttributesInTable(clone);
        return clone;
    }

    @Override
    public boolean equals(java.lang.Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof PublicKey) {
            PublicKey other = (PublicKey)otherObject;
            equal = this == other || super.equals(other) && this.subject_.equals(other.subject_) && this.encrypt_.equals(other.encrypt_) && this.verify_.equals(other.verify_) && this.verifyRecover_.equals(other.verifyRecover_) && this.wrap_.equals(other.wrap_) && this.trusted_.equals(other.trusted_) && this.wrapTemplate_.equals(other.wrapTemplate_);
        }
        return equal;
    }

    public ByteArrayAttribute getSubject() {
        return this.subject_;
    }

    public BooleanAttribute getEncrypt() {
        return this.encrypt_;
    }

    public BooleanAttribute getVerify() {
        return this.verify_;
    }

    public BooleanAttribute getVerifyRecover() {
        return this.verifyRecover_;
    }

    public BooleanAttribute getWrap() {
        return this.wrap_;
    }

    public BooleanAttribute getTrusted() {
        return this.trusted_;
    }

    public AttributeArray getWrapTemplate() {
        return this.wrapTemplate_;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(super.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Subject (DER, hex): ");
        buffer.append(this.subject_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Encrypt: ");
        buffer.append(this.encrypt_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Verify: ");
        buffer.append(this.verify_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Verify Recover: ");
        buffer.append(this.verifyRecover_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Wrap: ");
        buffer.append(this.wrap_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Trusted: ");
        buffer.append(this.trusted_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Wrap Template: ");
        buffer.append(this.wrapTemplate_.toString());
        return buffer.toString();
    }
}

