/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.UniqueIvParameters;
import iaik.pkcs.pkcs11.wrapper.CK_CCM_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class CcmParameters
extends UniqueIvParameters
implements Parameters {
    protected long ulDataLen;
    protected byte[] pNonce;
    protected byte[] pAad;
    protected long ulMacLen;

    public CcmParameters(long ulDataLen, byte[] pNonce, byte[] pAad, long ulMacLen) {
        if (pNonce.length < 7 || pNonce.length > 13) {
            throw new IllegalArgumentException("Illegal nonce size! Must be between 7 and 13");
        }
        if (ulMacLen != 4L && ulMacLen != 6L && ulMacLen != 8L && ulMacLen != 10L && ulMacLen != 12L && ulMacLen != 14L && ulMacLen != 16L) {
            throw new IllegalArgumentException("Invalid MAC length. Valid values are: 4, 6, 8, 10, 12, 14 or 16");
        }
        this.ulDataLen = ulDataLen;
        this.pNonce = pNonce;
        this.pAad = pAad;
        this.ulMacLen = ulMacLen;
    }

    public Object clone() {
        if (this.pAad != null) {
            return new CcmParameters(this.ulDataLen, (byte[])this.pNonce.clone(), (byte[])this.pAad.clone(), this.ulMacLen);
        }
        return new CcmParameters(this.ulDataLen, (byte[])this.pNonce.clone(), null, this.ulMacLen);
    }

    @Override
    public Object getPKCS11ParamsObject() {
        CK_CCM_PARAMS target = new CK_CCM_PARAMS();
        target.ulDataLen = this.ulDataLen;
        target.pNonce = this.pNonce;
        target.pAAD = this.pAad;
        target.ulMacLen = this.ulMacLen;
        target.pointer = this.pointer;
        target.length = this.length;
        this.pointer = 0L;
        this.length = 0L;
        return target;
    }

    public void setValuesFromPKCS11Object(Object object) {
        if (!(object instanceof CK_CCM_PARAMS)) {
            return;
        }
        CK_CCM_PARAMS source = (CK_CCM_PARAMS)object;
        this.ulDataLen = source.ulDataLen;
        this.pNonce = source.pNonce;
        this.pAad = source.pAAD;
        this.ulMacLen = source.ulMacLen;
        this.pointer = source.pointer;
        this.length = source.length;
        source.pointer = 0L;
        source.length = 0L;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("pNonce: ");
        buffer.append(Functions.toHexString(this.pNonce));
        return buffer.toString();
    }

    public boolean equals(Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof CcmParameters) {
            CcmParameters other = (CcmParameters)otherObject;
            equal = this == other || super.equals(other) && Functions.equals(this.pNonce, other.pNonce) && Functions.equals(this.pAad, other.pAad) && this.ulMacLen == other.ulMacLen && this.ulDataLen == other.ulDataLen;
        }
        return equal;
    }

    public int hashCode() {
        return super.hashCode() ^ Functions.hashCode(this.pNonce) ^ Functions.hashCode(this.pAad) ^ new Long(this.ulDataLen).hashCode() ^ new Long(this.ulDataLen).hashCode();
    }
}

