/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.rain.component;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.component.api.UIOutcomeTarget;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menuitem.UIMenuItem;
import org.primefaces.component.submenu.UISubmenu;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.Separator;
import org.primefaces.model.menu.Submenu;
import org.primefaces.rain.component.RainMenu;
import org.primefaces.util.AjaxRequestBuilder;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.WidgetBuilder;

public class RainMenuRenderer
extends BaseMenuRenderer {
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        RainMenu menu = (RainMenu)abstractMenu;
        ResponseWriter writer = context.getResponseWriter();
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        String defaultStyleClass = "layout-menu";
        styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        writer.startElement("ul", (UIComponent)menu);
        writer.writeAttribute("id", (Object)menu.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (menu.getElementsCount() > 0) {
            this.encodeElements(context, menu, menu.getElements(), true);
        }
        writer.endElement("ul");
    }

    protected void encodeElements(FacesContext context, AbstractMenu menu, List<MenuElement> elements, boolean root) throws IOException {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            this.encodeElement(context, menu, elements.get(i), root);
        }
    }

    protected void encodeElement(FacesContext context, AbstractMenu menu, MenuElement element, boolean root) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (element.isRendered()) {
            if (element instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)element;
                String menuItemClientId = menuItem instanceof UIComponent ? menuItem.getClientId() : menu.getClientId(context) + "_" + menuItem.getClientId();
                String containerStyle = menuItem.getContainerStyle();
                String containerStyleClass = menuItem.getContainerStyleClass();
                writer.startElement("li", null);
                writer.writeAttribute("id", (Object)menuItemClientId, null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                if (containerStyle != null) {
                    writer.writeAttribute("style", (Object)containerStyle, null);
                }
                if (containerStyleClass != null) {
                    writer.writeAttribute("class", (Object)containerStyleClass, null);
                }
                this.encodeMenuItem(context, menu, menuItem);
                writer.endElement("li");
            } else if (element instanceof Submenu) {
                Submenu submenu = (Submenu)element;
                String submenuClientId = submenu instanceof UIComponent ? ((UIComponent)submenu).getClientId() : menu.getClientId(context) + "_" + submenu.getId();
                String style = submenu.getStyle();
                String styleClass = submenu.getStyleClass();
                String className = root ? (styleClass != null ? styleClass + " layout-root-menuitem" : "layout-root-menuitem") : styleClass;
                writer.startElement("li", null);
                writer.writeAttribute("id", (Object)submenuClientId, null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                if (style != null) {
                    writer.writeAttribute("style", (Object)style, null);
                }
                if (className != null) {
                    writer.writeAttribute("class", (Object)className, null);
                }
                this.encodeSubmenu(context, menu, submenu, root);
                writer.endElement("li");
            } else if (element instanceof Separator) {
                this.encodeSeparator(context, (Separator)element);
            }
        }
    }

    protected void encodeSubmenu(FacesContext context, AbstractMenu menu, Submenu submenu, boolean root) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getIcon();
        String label = submenu.getLabel();
        int childrenElementsCount = submenu.getElementsCount();
        if (root) {
            writer.startElement("div", null);
            if (label != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"layout-menuitem-text", null);
                writer.writeText((Object)label, null);
                writer.endElement("span");
            }
            writer.endElement("div");
        }
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        this.encodeItemIcon(context, icon);
        if (label != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"layout-menuitem-text", null);
            writer.writeText((Object)label, null);
            writer.endElement("span");
            this.encodeToggleIcon(context, submenu, childrenElementsCount);
            if (submenu instanceof UISubmenu) {
                this.encodeBadge(context, ((UISubmenu)submenu).getAttributes().get("badge"));
            }
        }
        writer.endElement("a");
        if (label != null) {
            this.encodeTooltip(context, label);
        }
        if (childrenElementsCount > 0) {
            writer.startElement("ul", null);
            writer.writeAttribute("role", (Object)"menu", null);
            this.encodeElements(context, menu, submenu.getElements(), root);
            writer.endElement("ul");
        }
    }

    protected void encodeItemIcon(FacesContext context, String icon) throws IOException {
        if (icon != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("i", null);
            if (icon.contains("fa")) {
                icon = icon + " fa-fw";
            }
            writer.writeAttribute("class", (Object)(icon + " layout-menuitem-icon"), null);
            writer.endElement("i");
        }
    }

    protected void encodeToggleIcon(FacesContext context, Submenu submenu, int childrenElementsCount) throws IOException {
        if (childrenElementsCount > 0) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("i", null);
            writer.writeAttribute("class", (Object)"pi pi-chevron-down layout-submenu-toggler ", null);
            writer.endElement("i");
        }
    }

    protected void encodeBadge(FacesContext context, Object value) throws IOException {
        if (value != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"menuitem-badge", null);
            writer.writeText((Object)value.toString(), null);
            writer.endElement("span");
        }
    }

    protected void encodeSeparator(FacesContext context, Separator separator) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = separator.getStyle();
        String styleClass = separator.getStyleClass();
        styleClass = styleClass == null ? "Separator" : "Separator " + styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.endElement("li");
    }

    protected void encodeMenuItem(FacesContext context, AbstractMenu menu, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String title = menuitem.getTitle();
        boolean disabled = menuitem.isDisabled();
        Object value = menuitem.getValue();
        String style = menuitem.getStyle();
        String styleClass = menuitem.getStyleClass();
        writer.startElement("a", null);
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (disabled) {
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)"return false;", null);
        } else {
            String onclick = menuitem.getOnclick();
            if (menuitem.getUrl() != null || menuitem.getOutcome() != null) {
                String targetURL = this.getTargetURL(context, (UIOutcomeTarget)menuitem);
                writer.writeAttribute("href", (Object)targetURL, null);
                if (menuitem.getTarget() != null) {
                    writer.writeAttribute("target", (Object)menuitem.getTarget(), null);
                }
            } else {
                String command;
                writer.writeAttribute("href", (Object)"#", null);
                UIForm form = ComponentTraversalUtils.closestForm((FacesContext)context, (UIComponent)menu);
                if (form == null) {
                    throw new FacesException("MenuItem must be inside a form element");
                }
                if (menuitem.isDynamic()) {
                    String menuClientId = menu.getClientId(context);
                    LinkedHashMap<String, List<String>> params = menuitem.getParams();
                    if (params == null) {
                        params = new LinkedHashMap<String, List<String>>();
                    }
                    ArrayList<String> idParams = new ArrayList<String>();
                    idParams.add(menuitem.getId());
                    params.put(menuClientId + "_menuid", idParams);
                    command = menuitem.isAjax() ? this.createAjaxRequest(context, menu, (AjaxSource)menuitem, (UIComponent)form, params) : this.buildNonAjaxRequest(context, (UIComponent)menu, (UIComponent)form, menuClientId, params, true);
                } else {
                    command = menuitem.isAjax() ? this.createAjaxRequest(context, (AjaxSource)menuitem, (UIComponent)form) : this.buildNonAjaxRequest(context, (UIComponent)menuitem, (UIComponent)form, ((UIComponent)menuitem).getClientId(context), true);
                }
                String string = onclick = onclick == null ? command : onclick + ";" + command;
            }
            if (onclick != null) {
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
        }
        this.encodeMenuItemContent(context, menu, menuitem);
        writer.endElement("a");
        if (value != null) {
            this.encodeTooltip(context, value);
        }
    }

    protected void encodeMenuItemContent(FacesContext context, AbstractMenu menu, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = menuitem.getIcon();
        Object value = menuitem.getValue();
        if (menuitem instanceof UIMenuItem) {
            this.encodeBadge(context, ((UIMenuItem)menuitem).getAttributes().get("badge"));
        }
        this.encodeItemIcon(context, icon);
        if (value != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"layout-menuitem-text", null);
            writer.writeText(value, "value");
            writer.endElement("span");
        }
    }

    protected void encodeTooltip(FacesContext context, Object value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"layout-menu-tooltip", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"layout-menu-tooltip-arrow", null);
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"layout-menu-tooltip-text", null);
        writer.writeText(value, null);
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        RainMenu menu = (RainMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Rain", menu.resolveWidgetVar(), clientId).finish();
    }

    protected String createAjaxRequest(FacesContext context, AjaxSource source, UIComponent form) {
        UIComponent component = (UIComponent)source;
        String clientId = component.getClientId(context);
        AjaxRequestBuilder builder = this.getAjaxRequestBuilder();
        builder.init().source(clientId).form(SearchExpressionFacade.resolveClientId((FacesContext)context, (UIComponent)component, (String)source.getForm())).process(component, source.getProcess()).update(component, source.getUpdate()).async(source.isAsync()).global(source.isGlobal()).delay(source.getDelay()).timeout(source.getTimeout()).partialSubmit(source.isPartialSubmit(), source.isPartialSubmitSet(), source.getPartialSubmitFilter()).resetValues(source.isResetValues(), source.isResetValuesSet()).ignoreAutoUpdate(source.isIgnoreAutoUpdate()).onstart(source.getOnstart()).onerror(source.getOnerror()).onsuccess(source.getOnsuccess()).oncomplete(source.getOncomplete()).params(component);
        if (form != null) {
            builder.form(form.getClientId(context));
        }
        builder.preventDefault();
        return builder.build();
    }

    protected String createAjaxRequest(FacesContext context, AbstractMenu menu, AjaxSource source, UIComponent form, Map<String, List<String>> params) {
        String clientId = menu.getClientId(context);
        AjaxRequestBuilder builder = this.getAjaxRequestBuilder();
        builder.init().source(clientId).process((UIComponent)menu, source.getProcess()).update((UIComponent)menu, source.getUpdate()).async(source.isAsync()).global(source.isGlobal()).delay(source.getDelay()).timeout(source.getTimeout()).partialSubmit(source.isPartialSubmit(), source.isPartialSubmitSet(), source.getPartialSubmitFilter()).resetValues(source.isResetValues(), source.isResetValuesSet()).ignoreAutoUpdate(source.isIgnoreAutoUpdate()).onstart(source.getOnstart()).onerror(source.getOnerror()).onsuccess(source.getOnsuccess()).oncomplete(source.getOncomplete()).params(params);
        if (form != null) {
            builder.form(form.getClientId(context));
        }
        builder.preventDefault();
        return builder.build();
    }

    protected AjaxRequestBuilder getAjaxRequestBuilder() {
        AjaxRequestBuilder builder;
        Class<?> rootContext;
        try {
            rootContext = Class.forName("org.primefaces.context.PrimeRequestContext");
        }
        catch (ClassNotFoundException ex) {
            try {
                rootContext = Class.forName("org.primefaces.context.RequestContext");
            }
            catch (ClassNotFoundException ex1) {
                throw new RuntimeException(ex1);
            }
        }
        try {
            Method method = rootContext.getMethod("getCurrentInstance", new Class[0]);
            Object requestContextInstance = method.invoke(null, new Object[0]);
            method = requestContextInstance.getClass().getMethod("getAjaxRequestBuilder", new Class[0]);
            builder = (AjaxRequestBuilder)method.invoke(requestContextInstance, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return builder;
    }
}

